pro webplots

;
; program to plot 1-Hour averaged ULEIS data 
; Original M. Desai 2/13/04
;
common paths, work_dir
common times, timall, start_date, end_date, syr, sdoy, eyr, edoy
common files, input_file, save_file, output_file, output_file2, create_save_file

; sort out the time array

days_94 = 365.
days_95 = 365.
days_96 = 366.
days_97 = 365.
days_98 = 365.
days_99 = 365.
days_00 = 366.
days_01 = 365.
days_02 = 365.
days_03 = 365.
days_04 = 366.
days_05 = 365.
days_06 = 365.
days_07 = 365.
days_08 = 366.
days_09 = 365.
days_10 = 365.
days_11 = 365.
days_12 = 366.

dbegt = 276.

plot_magswe = 0

!p.thick    = 2
!x.ticklen  = 0.08
!y.ticklen  = 0.04      
!x.thick=2
!y.thick=2
csize=2.5
syms  = 0
ebars = 1
lthick = 5
ssize = 1.0


;time_array = intarr(8)
;time_filename = '4day_times.dat'
;time_range    = read_ascii(time_filename,data_start=0,count=number_data_points)
;
;
;knos = 572L
;while (knos lt number_data_points) do begin
;
;; get time range
;
;timall = time_range.(0)(*,knos)
; store into timall [syr, sdoy, shr, smin, eyr, edoy, ehr, emin]
  
@time_limits
time,timall(0:3),timall(4:7)

tim_all = timall

if (tim_all(0) gt 95) then begin
   tim_all(0) = 1900 + tim_all(0)
endif

if (tim_all(0) lt 95) then begin
   tim_all(0) = 2000 + tim_all(0)
endif

if (tim_all(4) gt 95) then begin
   tim_all(4) = 1900 + tim_all(4)
endif

if (tim_all(4) lt 95) then begin
   tim_all(4) = 2000 + tim_all(4)
endif

sh_tim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
  format="(i4,'_',i3.3,'_',i4,'_',i3.3)")

; no needed, sh_tim has no blanks
;sh_tim = strcompress(sh_tim,/remove)

; not needed, we are given time frame, don't need to compute it
;file_name  = '4day_times.dat'
;day_times  = read_ascii(file_name,data_start=0,count=data_points)

new_timall = timall

tim_all = intarr(8)
shtim    = strarr(1)
file_name1 = strarr(1)
; don't need second filename as we are doing only one 4-day segment
;file_name2 = strarr(1)

begt = hours(timall(0:1),[95,1]) + timall(2) + timall(3)/60.
endt = hours(timall(4:5),[95,1]) + timall(6) + timall(7)/60.

; don't need loop as we are doing only one file
;kpos = 0L
; while (kpos lt data_points) do begin

; replace following args with start, end dates we read in
;    file_start = hours(day_times.(0)(0:1,kpos),[95,1]) 
;    file_stop  = hours(day_times.(0)(4:5,kpos),[95,1]) 
    file_start = hours(timall(0:1),[95,1]) 
    file_stop = hours(timall(4:5),[95,1]) 

; don't need because we give IDL the correct filename
;if (begt ge file_start) and (begt le file_stop) then begin
  start_year = timall(0)
  start_day  = timall(1)
  start_hour = timall(2)
  start_mins = timall(3)
 
  stop_year  = timall(4)
  stop_day   = timall(5)
  stop_hour  = timall(6)
  stop_mins  = timall(7)

; not needed, timall is already y2k compliant 
;if (start_year gt 95) then begin
;   start_year = 1900 + start_year
;endif
;
;if (start_year lt 95) then begin
;   start_year = 2000 + start_year
;endif
;
;if (stop_year gt 95) then begin
;   stop_year = 1900 + stop_year
;endif
;
;if (stop_year lt 95) then begin
;   stop_year = 2000 + stop_year
;endif

; not needed, timall and tim_all are identical at this point
;tim_all = [start_year,start_day,start_hour,start_mins,stop_year,stop_day,stop_hour,stop_mins]
tim_all = timall

; none of the following needed because exact filename was passed to us
;if (start_day le 9) then begin
;    shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;       format="(i4,'_00',i1,'_',i4,'_',i3)")
;    
;        if (stop_day le 9) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_00',i1,'_',i4,'_00',i1)")
;        endif 
;
;        if (stop_day gt 9) and (stop_day le 99) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_00',i1,'_',i4,'_0',i2)")    
;        endif 
;
;        if (stop_day gt 99) and (stop_day le 999) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;              format="(i4,'_00',i1,'_',i4,'_',i3)")    
;        endif 
;                 
;endif 
;
;if (start_day gt 9) and (start_day le 99) then begin
;    shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;       format="(i4,'_0',i2,'_',i4,'_',i3)")
;     
;     if (stop_day le 9) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_0',i2,'_',i4,'_00',i1)")
;        endif 
;
;        if (stop_day gt 9) and (stop_day le 99) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_0',i2,'_',i4,'_0',i2)")    
;        endif 
;
;        if (stop_day gt 99) and (stop_day le 999) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;              format="(i4,'_0',i2,'_',i4,'_',i3)")    
;        endif 
;                    
;endif 
;
;if (start_day gt 99) and (start_day le 999) then begin
;    shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;       format="(i4,'_',i3,'_',i4,'_',i3)")
;       
;        
;     if (stop_day le 9) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_',i3,'_',i4,'_00',i1)")
;        endif 
;
;        if (stop_day gt 9) and (stop_day le 99) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_',i3,'_',i4,'_0',i2)")    
;        endif 
;
;        if (stop_day gt 99) and (stop_day le 999) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;              format="(i4,'_',i3,'_',i4,'_',i3)")    
;        endif 
;                    
;endif  
shtim = sh_tim  ; same as shtim, already computed

; later on change this to derive file_name1 9name of save file) from name of input data file

file_name1 = work_dir+"phaspect_"+shtim+".sav" 


;if (kpos lt data_points) and (endt gt file_stop) then begin
;
;  start_year = fix(day_times.(0)(0,kpos+1))
;  start_day  = fix(day_times.(0)(1,kpos+1))
;  start_hour = fix(day_times.(0)(2,kpos+1))
;  start_mins = fix(day_times.(0)(3,kpos+1))
; 
;  stop_year  = fix(day_times.(0)(4,kpos+1))
;  stop_day   = fix(day_times.(0)(5,kpos+1))
;  stop_hour  = fix(day_times.(0)(6,kpos+1))
;  stop_mins  = fix(day_times.(0)(7,kpos+1))
; 
;if (start_year gt 95) then begin
;   start_year = 1900 + start_year
;endif
;
;if (start_year lt 95) then begin
;   start_year = 2000 + start_year
;endif
;
;if (stop_year gt 95) then begin
;   stop_year = 1900 + stop_year
;endif
;
;if (stop_year lt 95) then begin
;   stop_year = 2000 + stop_year
;endif
;
;
;tim_all = [start_year,start_day,start_hour,start_mins,stop_year,stop_day,stop_hour,stop_mins]
;
;if (start_day le 9) then begin
;    shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;       format="(i4,'_00',i1,'_',i4,'_',i3)")
;    
;        if (stop_day le 9) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_00',i1,'_',i4,'_00',i1)")
;        endif 
;
;        if (stop_day gt 9) and (stop_day le 99) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_00',i1,'_',i4,'_0',i2)")    
;        endif 
;
;        if (stop_day gt 99) and (stop_day le 999) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;              format="(i4,'_00',i1,'_',i4,'_',i3)")    
;        endif 
;                 
;endif 
;
;if (start_day gt 9) and (start_day le 99) then begin
;    shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;       format="(i4,'_0',i2,'_',i4,'_',i3)")
;     
;     if (stop_day le 9) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_0',i2,'_',i4,'_00',i1)")
;        endif 
;
;        if (stop_day gt 9) and (stop_day le 99) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_0',i2,'_',i4,'_0',i2)")    
;        endif 
;
;        if (stop_day gt 99) and (stop_day le 999) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;              format="(i4,'_0',i2,'_',i4,'_',i3)")    
;        endif 
;                    
;endif 
;
;if (start_day gt 99) and (start_day le 999) then begin
;    shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;       format="(i4,'_',i3,'_',i4,'_',i3)")
;       
;        
;     if (stop_day le 9) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_',i3,'_',i4,'_00',i1)")
;        endif 
;
;        if (stop_day gt 9) and (stop_day le 99) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;             format="(i4,'_',i3,'_',i4,'_0',i2)")    
;        endif 
;
;        if (stop_day gt 99) and (stop_day le 999) then begin
;           shtim = string(tim_all(0),tim_all(1),tim_all(4),tim_all(5), $
;              format="(i4,'_',i3,'_',i4,'_',i3)")    
;        endif 
;endif 
; file_name2 = work_dir+"phaspect_"+shtim+".sav"
; second_file = 1 
;                                        
;endif else begin
;
  file_name2 = 0
  second_file = 0  
;endelse  
;
;endif
;
; kpos = kpos + 1
;endwhile
   
; instead of reading from a constructed name, read from save filename that
; corresponds to the first input file (spect data).  The routine initialize
; stored this into save_file(0).

;restore,file_name1
;phadata_1   = xdf.data
restore,save_file(0)

; Rerun initialization routine in case anything changed

initialize

; Extract saved species pha data from structure xdf.data and store it into
; a separate array named phadata.  Although this is later copied into data,
; we still need to copy it into phadata first.  That array is used later on
; to hold smoosh and mass data, and their rank is less that that of the species
; pha data, so storing species into phatadata first sizes the array large enough
; to hold the other data sets.

phadata   = xdf.data

n_size = size(phadata)

data = phadata
help,data

; sort out the time arrays in hours

data_tms = fltarr(n_elements(data(*,1)))

for i = 0L, n_elements(data_tms) - 1 do begin
   if (data(i,0) eq 1995.) then $    
         data_tms(i) = data(i,1) else $
   if (data(i,0) eq 1996.) then $    
         data_tms(i) =  days_95 + data(i,1) else $
   if (data(i,0) eq 1997.) then $
         data_tms(i) =  days_95 + days_96 + data(i,1) else $
   if (data(i,0) eq 1998.) then $    
         data_tms(i) =  days_95 + days_96 + days_97 + data(i,1) else $
   if (data(i,0) eq 1999.) then $    
         data_tms(i) =  days_95 + days_96 + days_97 + days_98 + data(i,1) else $
   if (data(i,0) eq 2000.) then $    
         data_tms(i) =  days_95 + days_96 + days_97 + days_98 + days_99 + data(i,1) else $ 
   if (data(i,0) eq 2001.) then $    
         data_tms(i) =  days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + data(i,1) else $
   if (data(i,0) eq 2002.) then $    
         data_tms(i) = days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + days_01 + data(i,1) else $
   if (data(i,0) eq 2003.) then $    
         data_tms(i) = days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + days_01 + days_02 + data(i,1) else $
   if (data(i,0) eq 2004.) then $    
         data_tms(i) = days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + days_01 + days_02 + days_03 + data(i,1) else $      
   if (data(i,0) eq 2005.) then $    
         data_tms(i) = days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + days_01 + days_02 + days_03 + days_04 + data(i,1) else $      
   if (data(i,0) eq 2006.) then $    
         data_tms(i) = days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + days_01 + days_02 + days_03 + days_04 + days_05 + data(i,1) else $      
   if (data(i,0) eq 2007.) then $    
         data_tms(i) = days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + days_01 + days_02 + days_03 + days_04 + days_05 + days_06 + data(i,1) else $                                              
         data_tms(i) = days_95 + days_96 + days_97 + days_98 + days_99 + days_00 + days_01 + days_02 + days_03 + days_04 + days_05 + days_06 + days_07 + data(i,1) 
 endfor 
 
nhours = (data_tms(*) - fix(data_tms(*)))*24.0 + 24.0*(fix(data_tms(*)) - 1.0)

print,data(0,0),data(0,1),data(n_size(1)-1,1)


;
; set the plotting device

dme = 1
spect = 10
    
    pngfilename = output_file2
    dev = 'z'
    set_plot,dev
print,'Generating PNG plot to file ',pngfilename
 
if (dme eq 1) then begin               
  if (spect eq 10) then begin   
;     device,xsize=20,ysize=24
;     device,xoff=0.5,yoff=2.0
;    device,set_resolution=[778,834]
    xsize = !d.x_size
    ysize = !d.y_size
print,'xsize, ysize = ',xsize,ysize
  endif   
    !p.color=1  
    !p.font=0
endif
   
   ; set up a simple color table
   
        bbc = 255b
        bfg = 0b
        
    if (n_elements(red) eq 0) then begin
        red = [bbc, bfg, 255b, 0b, 0b, 0b, 255b, 255b, 255b, 127b, 0b, $
               0b, 127b, 255b, 85b, 170b]
        gre = [bbc, bfg, 0b, 255b, 0b, 255b, 0b, 255b, 127b, 255b, 255b, $
               127b, 0b, 0b, 85b, 170b]
        blu = [bbc, bfg, 0b, 0b, 255b, 255b, 255b, 0b, 0b, 0b, 127b, $
               255b, 255b, 127b, 85b, 170b]
    endif else begin
        red(0:1) = [bbc, bfg]
        gre(0:1) = [bbc, bfg]
        blu(0:1) = [bbc, bfg]
    endelse
    tvlct, red, gre, blu
    tvlct, bfg, bfg, bfg, !d.n_colors-1 

n = n_elements(red)
red = [red, bytarr(255-n), bfg]
gre = [gre, bytarr(255-n), bfg]
blu = [blu, bytarr(255-n), bfg]

;define a solid dot as a symbol

circ=findgen(16)*(!pi*2/16.)
usersym,cos(circ),sin(circ),/fill 
  
 plots_across = 1 ; # of plots across the page
 plots_down = 3; # of plots down the page 
   
!p.multi=[0,plots_across,plots_down,0,0]    

location = fltarr(plots_down,4)

location(0,*) = [0.09,0.6,0.8,0.85]
location(1,*) = [0.09,0.34,0.8,0.59]
location(2,*) = [0.09,0.08,0.8,0.33]
      
iyear = tstart(0)
iday  = tstart(1)

ih = timall(2)
im = timall(3)
eh = timall(6)
em = timall(7)

; get the data only for the given start and stop times                 

begt = hours(timall(0:1),[95,1]) + timall(2) + timall(3)/60.
endt = hours(timall(4:5),[95,1]) + timall(6) + timall(7)/60.

stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)  

n_days = round((endt-begt)/24.)
doy = intarr(n_days + 1)
doy    = tim_all(1) + indgen(n_days+1)
yy     = intarr(n_days + 1) 

date_string = strarr(n_days +1)

for i  = 0, n_days do begin
yy(i)  = tim_all(0)    
doy(i) = doy(i)    
if (yy(i) mod 4 eq 0) then begin
   if (doy(i) ge 367) then begin
      doy(i) = doy(i) - 366
      yy(i)  = yy(i) + 1
   endif
endif else begin
   if (doy(i) ge 366) then begin
      doy(i) = doy(i) - 365
      yy(i)  = yy(i) + 1
   endif
endelse   
    if (i eq 0) then begin
      date_string(i) = string(yy(i),doy(i),$
         format="(i4,'/',i3)")
   endif else begin
       date_string(i) = string(doy(i),$
         format="(i3)")
   endelse         
    date_string(i) = strcompress(date_string(i),/remove)   
endfor    

locs_max = where(nhours ge begt and nhours le endt, countm)
 if (countm gt 1) then begin
   max_value = max(data(locs_max,5))
     if (max_value lt 100) then begin
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n']
       !y.ticks    = 5
       crangey     = [1e-3,1e+2]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2] 
     endif else begin
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
       !y.ticks    = 7
       crangey     = [1e-3,1e+4]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 
     endelse
 endif else begin 
       !y.tickname = ['10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
       !y.ticks    = 7
       crangey     = [1e-3,1e+4]
       !y.minor    = 9
       !y.tickv    = [1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 
 endelse 

; plot proton rates

crangex = [stime,etime]
!p.position = location(0,*)

      timebox, stime, etime, /zero, exact=texact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize/1.2,$
      ytitle='#/(cm!U2!n s sr MeV/n.)',$
      nolabels=1, minutes = minutes, date = 0,noerase = 0    
      
;xyouts,/norm,0.01,0.95,shtim,charsize=csize/3.
;xyouts,/norm,0.02,0.93,'Top Panel: ACE/ULEIS - 0.23-0.32 MeV/n. Intensity',charsize=csize/3.5
;xyouts,/norm,0.02,0.91,'Middle Panel: ACE/ULEIS - Mass Range = 2-70 AMU; Energy range = 0.4-10 MeV/n.',charsize=csize/3.5
;xyouts,/norm,0.02,0.89,'Bottom Panel: ACE/ULEIS - Mass Range = 10-70 AMU; Energy range = 0.03-10 MeV/n.',charsize=csize/3.5

xyouts,/norm,0.03,0.89,'Top: 0.23-0.32 MeV/n. Intensity; Middle: Energy range = 0.4-10 MeV/n.; Bottom: Mass Range = 10-70 AMU',charsize=csize/3.5,align=0.0

xyouts,/norm,0.8,0.91,'Created-'+systime(),align=0,charsize = csize/4.5
;xyouts,/norm,0.83,0.84,'Updated ACE Shock List',align=0,charsize = csize/4.5
;xyouts,/norm,0.83,0.83,'through 2003 Nov. 6 (DOY 310)',align=0,charsize = csize/4.5

time_ticks = stime + indgen(n_days+1)*24

for i = 0, n_days do begin
  xyouts,/data,time_ticks(i),crangey(1)*1.5,date_string(i),align =0.5,charsize=csize/3.
endfor  

!p.color=4
;xyouts,/norm,0.9,0.81,'TF - CME F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.79,'TR - CME R/S',align=0,charsize = csize/4
!p.color=1

!p.color=2
;xyouts,/norm,0.9,0.77,'CF - CIR F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.75,'CR - CIR R/S',align=0,charsize = csize/4
!p.color=1

locs = where(nhours ge begt, countm)
if (countm eq 0) then goto, dofont
if countm ne 0 then resultm = nhours(locs)
locsp = where (resultm le endt, countp)
if (countp eq 0) then goto, dofall
if countp ne 0 then resultp = resultm(locsp)
nelm = n_elements(locsp)
nume = locs(0:nelm-1)                    

 
    col_index = intarr(3)
    col_index = [1,2,3]
    
         !p.color=col_index(0)
         !p.thick=1
         oplot,nhours(nume)-begt+ih,data(nume,3),thick=lthick
         xyouts,/data,etime,5e-2,'!U3!nHe',align = -0.2,charsize = csize/3.5
         !p.color = 1 
  
    col_index = intarr(3)
    col_index = [4,3,2]
            
       !p.thick=0.1
       
       !p.color=col_index(0)
       !p.thick=1       
       oplot,nhours(nume)-begt+ih,data(nume,5),thick=lthick
       xyouts,/data,etime,1e0,'!U4!nHe',align = -0.2,charsize = csize/3.5
       !p.color = 1
     
    col_index = intarr(3)
    col_index = [2,3,4]
                  
       !p.thick=0.1
       
       !p.color = col_index(0)
       oplot,nhours(nume)-begt+ih,data(nume,7),thick=lthick
       xyouts,/data,etime,5e-3,'O',align = -0.2,charsize = csize/3.5
       !p.color = 1

    col_index = intarr(2)
    col_index = [3,2]
    
       !p.thick=0.1
             
       !p.thick=0.1
       !p.color = col_index(0)
       oplot,nhours(nume)-begt+ih,data(nume,9),thick=lthick
       xyouts,/data,etime,1e-3,'Fe',align = -0.2,charsize = csize/3.5
       !p.color = 1
        
type_axis = intarr(1)
type_axis = 1
;plot_aceshocks,timall,crangey,type_axis
;plot_sattimes,timall,crangey
;plot_shocktimes,timall,crangey
;plot_bdetimes,timall,crangey
;plot_upstreamtimes,timall,crangey

crangex = [stime,etime]
;print_times,crangey,crangex,timall

dofall:
dofont:

if (countm le 0) then begin
 stime = 0. + ih
 etime = endt - begt + ih

 tst = timall(0:1)  

!y.tickname = ['10!U-4!n','10!U-3!n','10!U-2!n','10!U-1!n','10!U0!n','10!U1!n','10!U2!n','10!U3!n','10!U4!n']
!y.ticks    = 8
crangey     = [1e-4,1e+4]
!y.minor    = 9
!y.tickv    = [1e-4,1e-3,1e-2,1e-1,1e0,1e1,1e2,1e3,1e4] 

; plot proton rates

crangex = [stime,etime]
!p.position = location(0,*)

      timebox, stime, etime, /zero, exact=texact, day=tst,ytype=1, $
      yrange = crangey, yexact = 1, charsize=csize,$
      ytitle='particles/(cm!U2!n s sr MeV/nuc)', $
      nolabels=1, minutes = minutes, date = 0,noerase = 0    

;xyouts,/norm,0.01,0.95,shtim,charsize=csize/3.
;xyouts,/norm,0.02,0.93,'Top Panel: ACE/ULEIS - 0.23-0.32 MeV/n. Intensity',charsize=csize/3.5
;xyouts,/norm,0.02,0.91,'Middle Panel: ACE/ULEIS - Mass Range = 2-70 AMU; Energy range = 0.4-10 MeV/n.',charsize=csize/3.5
;xyouts,/norm,0.02,0.89,'Bottom Panel: ACE/ULEIS - Mass Range = 10-70 AMU; Energy range = 0.03-10 MeV/n.',charsize=csize/3.5

;xyouts,/norm,0.445,0.89,'Top: 0.23-0.32 MeV/n. Intensity; Middle: Energy range = 0.4-10 MeV/n.; Bottom: Mass Range = 10-70 AMU',charsize=csize/3.5,align=0.5


time_ticks = stime + indgen(n_days+1)*24

for i = 0, n_days do begin
  xyouts,/data,time_ticks(i),crangey(1)*1.5,date_string(i),align =0.5,charsize=csize/3.
endfor  

xyouts,/data,stime+3,crangey(1)/5.,'NO DATA AVAILABLE FOR THIS PERIOD'

!p.color=4
;xyouts,/norm,0.9,0.81,'TF - CME F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.79,'TR - CME R/S',align=0,charsize = csize/4
!p.color=1

!p.color=2
;xyouts,/norm,0.9,0.77,'CF - CIR F/S',align=0,charsize = csize/4
;xyouts,/norm,0.9,0.75,'CR - CIR R/S',align=0,charsize = csize/4
!p.color=1

xyouts,/norm,0.03,0.89,'Top: 0.23-0.32 MeV/n. Intensity; Middle: Energy range = 0.4-10 MeV/n.; Bottom: Mass Range = 10-70 AMU',charsize=csize/3.5,align=0.0

xyouts,/norm,0.8,0.91,'Created-'+systime(),align=0,charsize = csize/4.5
;xyouts,/norm,0.83,0.84,'Updated ACE Shock List',align=0,charsize = csize/4.5
;xyouts,/norm,0.83,0.83,'through 2003 Nov. 6 (DOY 310)',align=0,charsize = csize/4.5

endif

;print
;print,'calling webplots_mass'
;print
;webplots_mass,timall,location,dme

;print
;print,'calling webplots_smoosh'
;print
;webplots_smoosh,timall,location,dme

;final_mass,timall,location,dme

;final_smoosh,timall,location,dme

;plot_saturation,timall,location
         
hires = 0

  ; plot_acevswbmag,timall,location,hires

;xyouts,0.09,0.6,'LL'
;xyouts,0.8,0.85,'UR'

; close plotting device
  
if (dme eq 0) then goto, docomp
  if (dme ne 0) then begin
;      device,/close
    a = tvrd()
    print,'Writing PNG plot to ',pngfilename
help,red
help,gre
help,blu
    write_png,pngfilename,a,red,gre,blu
    pos = strpos(pngfilename,'.PNG')
    jpegfilename = strmid(pngfilename,0,pos) + '.JPG'
    print,'Writing JPEG plot to ',jpegfilename
    write_jpeg,jpegfilename,a
  endif
docomp:


end

@init_webdata

initialize

end
